/* --------------------------------------------------------------
  About.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Add the "About" property in the global StyleEdit in order to get information
 * about the current installation of StyleEdit.
 *
 * @param {Object} StyleEdit The window.StyleEdit object.
 */
export default function(StyleEdit) {
	if (StyleEdit.Config.get('environment') === 'development') {
		const about = `StyleEdit v${StyleEdit.Config.get('version')} by Gambio GmbH ` 
			+ `${Date.today().toString('yyyy')}, All Rights Reserved`; 
		
		StyleEdit.About = about;
	}
}